/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Arrays;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;
import mage.util.RandomUtil;

class ParallelThoughtsSearchEffect
extends OneShotEffect {
    ParallelThoughtsSearchEffect() {
        super(Outcome.Neutral);
        this.staticText = "search your library for seven cards, exile them in a face-down pile, and shuffle that pile. Then shuffle your library";
    }

    private ParallelThoughtsSearchEffect(ParallelThoughtsSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParallelThoughtsSearchEffect copy() {
        return new ParallelThoughtsSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        CardsImpl cardsInExilePile = new CardsImpl();
        if (controller != null && permanent != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(7, new FilterCard());
            if (controller.searchLibrary(target, source, game)) {
                for (UUID targetId : target.getTargets()) {
                    Card card = controller.getLibrary().getCard(targetId, game);
                    if (card == null) continue;
                    cardsInExilePile.add(card);
                }
                UUID[] shuffled = (UUID[])cardsInExilePile.toArray((Object[])new UUID[0]);
                for (int n = shuffled.length - 1; n > 0; --n) {
                    int r = RandomUtil.nextInt((int)(n + 1));
                    UUID temp = shuffled[n];
                    shuffled[n] = shuffled[r];
                    shuffled[r] = temp;
                }
                cardsInExilePile.clear();
                cardsInExilePile.addAll(Arrays.asList(shuffled));
                String exileName = permanent.getIdName() + " (" + game.getState().getZoneChangeCounter(source.getSourceId()) + ")";
                for (Card card : cardsInExilePile.getCards(game)) {
                    controller.moveCardsToExile(card, source, game, false, CardUtil.getCardExileZoneId((Game)game, (Ability)source), exileName);
                    card.setFaceDown(true, game);
                }
                controller.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

