/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import mage.abilities.common.OneOrMoreDamagePlayerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.p.ParapetThrasherDamageEffect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.DefineByTriggerTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ParapetThrasherTriggeredAbility
extends OneOrMoreDamagePlayerTriggeredAbility {
    public ParapetThrasherTriggeredAbility(Effect effect, FilterPermanent filter) {
        super(Zone.BATTLEFIELD, effect, filter, true, true, SetTargetPointer.PLAYER, false);
        this.setTargetAdjuster((TargetAdjuster)DefineByTriggerTargetAdjuster.instance);
    }

    private ParapetThrasherTriggeredAbility(ParapetThrasherTriggeredAbility ability) {
        super((OneOrMoreDamagePlayerTriggeredAbility)ability);
    }

    public ParapetThrasherTriggeredAbility copy() {
        return new ParapetThrasherTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List events = this.getFilteredEvents((BatchEvent)((DamagedBatchForOnePlayerEvent)event), game);
        if (events.isEmpty()) {
            return false;
        }
        this.getAllEffects().setValue("damage", (Object)events.stream().mapToInt(GameEvent::getAmount).sum());
        Player damagedPlayer = game.getPlayer(event.getTargetId());
        FilterArtifactPermanent artifactFilter = new FilterArtifactPermanent("artifact " + damagedPlayer.getLogName() + " controls");
        artifactFilter.add((Predicate)new ControllerIdPredicate(damagedPlayer.getId()));
        this.getTargets().clear();
        this.addTarget((Target)new TargetPermanent((FilterPermanent)artifactFilter));
        for (Effect effect : this.getAllEffects()) {
            if (!(effect instanceof ParapetThrasherDamageEffect)) continue;
            effect.setTargetPointer((TargetPointer)new FixedTarget(damagedPlayer.getId()));
        }
        return true;
    }
}

