/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PariahsShieldEffect
extends ReplacementEffectImpl {
    PariahsShieldEffect() {
        super(Duration.WhileOnBattlefield, Outcome.RedirectDamage);
        this.staticText = "All damage that would be dealt to you is dealt to equipped creature instead";
    }

    private PariahsShieldEffect(PariahsShieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && (permanent = game.getPermanent(equipment.getAttachedTo())) != null) {
            DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
            permanent.damage(damageEvent.getAmount(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable());
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }

    public PariahsShieldEffect copy() {
        return new PariahsShieldEffect(this);
    }
}

