/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PartingThoughtsEffect
extends OneShotEffect {
    PartingThoughtsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Destroy target creature. You draw X cards and you lose X life, where X is the number of counters on that creature";
    }

    private PartingThoughtsEffect(PartingThoughtsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PartingThoughtsEffect copy() {
        return new PartingThoughtsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.destroy(source, game, false);
                int numberOfCounters = 0;
                for (Counter counter : permanent.getCounters(game).values()) {
                    numberOfCounters += counter.getCount();
                }
                if (numberOfCounters > 0) {
                    controller.drawCards(numberOfCounters, source, game);
                    controller.loseLife(numberOfCounters, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

