/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class PatchUpTarget
extends TargetCardInYourGraveyard {
    private static final FilterCard filterStatic = new FilterCreatureCard("creature cards with total mana value 3 or less from your graveyard");

    PatchUpTarget() {
        super(0, 3, filterStatic, false);
    }

    private PatchUpTarget(PatchUpTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public PatchUpTarget copy() {
        return new PatchUpTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return super.canTarget(playerId, id, source, game) && CardUtil.checkCanTargetTotalValueLimit((Collection)this.getTargets(), (UUID)id, MageObject::getManaValue, (int)3, (Game)game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        return CardUtil.checkPossibleTargetsTotalValueLimit((Collection)this.getTargets(), (Set)super.possibleTargets(sourceControllerId, source, game), MageObject::getManaValue, (int)3, (Game)game);
    }

    public String getMessage(Game game) {
        int selectedValue = this.getTargets().stream().map(arg_0 -> ((Game)game).getObject(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        return super.getMessage(game) + " (selected total mana value " + selectedValue + ")";
    }
}

