/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PathOfTheSchemerEffect
extends OneShotEffect {
    PathOfTheSchemerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you put a creature card from a graveyard onto the battlefield under your control. It's an artifact in addition to its other types";
    }

    private PathOfTheSchemerEffect(PathOfTheSchemerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PathOfTheSchemerEffect copy() {
        return new PathOfTheSchemerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(Outcome.PutCreatureInPlay, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        game.addEffect(new AddCardTypeTargetEffect(Duration.Custom, new CardType[]{CardType.ARTIFACT}).setTargetPointer((TargetPointer)new FixedTarget(new MageObjectReference((MageObject)card, game, 1))), source);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        return true;
    }
}

