/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PatientRebuildingEffect
extends OneShotEffect {
    PatientRebuildingEffect() {
        super(Outcome.DrawCard);
        this.staticText = "target opponent mills three cards, then you draw a card for each land card put into that graveyard this way";
    }

    private PatientRebuildingEffect(PatientRebuildingEffect effect) {
        super((OneShotEffect)effect);
    }

    public PatientRebuildingEffect copy() {
        return new PatientRebuildingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || player == null) {
            return false;
        }
        int numberOfLandCards = 0;
        Set movedCards = player.millCards(3, source, game).getCards(game);
        for (Card card : movedCards) {
            if (!card.isLand(game)) continue;
            ++numberOfLandCards;
        }
        if (numberOfLandCards > 0) {
            return controller.drawCards(numberOfLandCards, source, game) > 0;
        }
        return true;
    }
}

