/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class PatriarchsBiddingEffect
extends OneShotEffect {
    PatriarchsBiddingEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "each player chooses a creature type. Each player returns all creature cards of a type chosen this way from their graveyard to the battlefield";
    }

    private PatriarchsBiddingEffect(PatriarchsBiddingEffect effect) {
        super((OneShotEffect)effect);
    }

    public PatriarchsBiddingEffect copy() {
        return new PatriarchsBiddingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            HashSet<String> chosenTypes = new HashSet<String>();
            for (Object playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                ChoiceCreatureType typeChoice;
                Player player = game.getPlayer((UUID)playerId);
                if (!player.choose(Outcome.PutCreatureInPlay, (Choice)(typeChoice = new ChoiceCreatureType(game, source)), game)) continue;
                game.informPlayers(sourceObject.getLogName() + ": " + player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
                chosenTypes.add(typeChoice.getChoiceKey());
            }
            ArrayList<SubType.SubTypePredicate> predicates = new ArrayList<SubType.SubTypePredicate>();
            for (String type : chosenTypes) {
                predicates.add(SubType.byDescription((String)type).getPredicate());
            }
            FilterCreatureCard filter = new FilterCreatureCard();
            filter.add(Predicates.or(predicates));
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.moveCards(player.getGraveyard().getCards((FilterCard)filter, game), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

