/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PatronOfTheNezumiTriggeredAbility
extends TriggeredAbilityImpl {
    public PatronOfTheNezumiTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
    }

    private PatronOfTheNezumiTriggeredAbility(PatronOfTheNezumiTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && (permanent = game.getPermanentOrLKIBattlefield(zEvent.getTargetId())) != null && game.getOpponents(this.controllerId).contains(permanent.getOwnerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent.getOwnerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a permanent is put into an opponent's graveyard, that player loses 1 life.";
    }

    public PatronOfTheNezumiTriggeredAbility copy() {
        return new PatronOfTheNezumiTriggeredAbility(this);
    }
}

