/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PatronOfTheVeinExileCreatureEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    public PatronOfTheVeinExileCreatureEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it and put a +1/+1 counter on each Vampire you control";
    }

    private PatronOfTheVeinExileCreatureEffect(PatronOfTheVeinExileCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public PatronOfTheVeinExileCreatureEffect copy() {
        return new PatronOfTheVeinExileCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject sourceObject = source.getSourceObject(game);
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            ExileTargetEffect effect = new ExileTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            effect.apply(game, source);
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            game.informPlayers(sourceObject.getName() + ": Put a +1/+1 counter on " + permanent.getLogName());
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.VAMPIRE.getPredicate());
    }
}

