/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PeerPressureEffect
extends OneShotEffect {
    PeerPressureEffect() {
        super(Outcome.GainControl);
        this.staticText = "Choose a creature type. If you control more creatures of that type than each other player, you gain control of all creatures of that type";
    }

    private PeerPressureEffect(PeerPressureEffect effect) {
        super((OneShotEffect)effect);
    }

    public PeerPressureEffect copy() {
        return new PeerPressureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        if (controller != null && controller.choose(Outcome.GainControl, (Choice)choice, game)) {
            String chosenType = choice.getChoiceKey();
            game.informPlayers(controller.getLogName() + " has chosen " + chosenType);
            UUID playerWithMost = null;
            int maxControlled = 0;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                FilterCreaturePermanent filter = new FilterCreaturePermanent(SubType.byDescription((String)chosenType), chosenType);
                filter.add((Predicate)new ControllerIdPredicate(playerId));
                int controlled = new PermanentsOnBattlefieldCount((FilterPermanent)filter).calculate(game, source, (Effect)this);
                if (controlled > maxControlled) {
                    maxControlled = controlled;
                    playerWithMost = playerId;
                    continue;
                }
                if (controlled != maxControlled) continue;
                playerWithMost = null;
            }
            if (playerWithMost != null && playerWithMost.equals(controller.getId())) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterCreaturePermanent(SubType.byDescription((String)chosenType), chosenType), controller.getId(), source, game)) {
                    GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

