/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.CastSpellLastTurnWatcher;

class PeerlessSamuraiEffect
extends CostModificationEffectImpl {
    int spellsCast;

    public PeerlessSamuraiEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "the next spell you cast this turn costs {1} less to cast";
    }

    protected PeerlessSamuraiEffect(PeerlessSamuraiEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.spellsCast = effect.spellsCast;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher != null) {
            this.spellsCast = watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId());
        }
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)1);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher != null && watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId()) > this.spellsCast) {
            this.discard();
            return false;
        }
        if (abilityToModify instanceof SpellAbility) {
            return abilityToModify.isControlledBy(source.getControllerId());
        }
        return false;
    }

    public PeerlessSamuraiEffect copy() {
        return new PeerlessSamuraiEffect(this);
    }
}

