/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class PeltCollectorTriggeredAbility
extends TriggeredAbilityImpl {
    PeltCollectorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private PeltCollectorTriggeredAbility(PeltCollectorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).isDiesEvent();
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId()) || !event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        Permanent triggeringCreature = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (triggeringCreature == null) {
            return false;
        }
        this.getEffects().setValue("permanentEnteredOrDied", (Object)triggeringCreature);
        return true;
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent sourcePerm = this.getSourcePermanentIfItStillExists(game);
        if (sourcePerm == null) {
            return false;
        }
        Permanent permanent = null;
        for (Effect effect : this.getEffects()) {
            Object obj = effect.getValue("permanentEnteredOrDied");
            if (!(obj instanceof Permanent)) continue;
            permanent = (Permanent)obj;
            break;
        }
        return permanent != null && permanent.getPower().getValue() > sourcePerm.getPower().getValue();
    }

    public String getRule() {
        return "Whenever another creature you control enters or dies, if that creature's power is greater than {this}'s, put a +1/+1 counter on {this}.";
    }

    public PeltCollectorTriggeredAbility copy() {
        return new PeltCollectorTriggeredAbility(this);
    }
}

