/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PerimeterCaptainTriggeredAbility
extends TriggeredAbilityImpl {
    public PerimeterCaptainTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever a creature you control with defender blocks, ");
    }

    private PerimeterCaptainTriggeredAbility(PerimeterCaptainTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature = game.getPermanent(event.getSourceId());
        return creature != null && creature.isControlledBy(this.getControllerId()) && creature.getAbilities().contains((Ability)DefenderAbility.getInstance());
    }

    public PerimeterCaptainTriggeredAbility copy() {
        return new PerimeterCaptainTriggeredAbility(this);
    }
}

