/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PerishTheThoughtEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card in target opponent's hand");

    public PerishTheThoughtEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target opponent reveals their hand. You choose a card from it. That player shuffles that card into their library";
    }

    private PerishTheThoughtEffect(PerishTheThoughtEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerishTheThoughtEffect copy() {
        return new PerishTheThoughtEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = source.getSourceObject(game);
        if (targetOpponent != null && sourceObject != null) {
            if (!targetOpponent.getHand().isEmpty()) {
                targetOpponent.revealCards(sourceObject.getIdName(), targetOpponent.getHand(), game);
                Player you = game.getPlayer(source.getControllerId());
                if (you != null) {
                    Card chosenCard;
                    TargetCard target = new TargetCard(Zone.HAND, filter);
                    target.withNotTarget(true);
                    if (you.choose(Outcome.Neutral, targetOpponent.getHand(), target, source, game) && (chosenCard = targetOpponent.getHand().get(target.getFirstTarget(), game)) != null) {
                        targetOpponent.shuffleCardsToLibrary(chosenCard, game, source);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

