/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.PermanentsEnteredBattlefieldWatcher;

enum PermafrostTrapCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        PermanentsEnteredBattlefieldWatcher watcher = (PermanentsEnteredBattlefieldWatcher)game.getState().getWatcher(PermanentsEnteredBattlefieldWatcher.class);
        if (watcher != null) {
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                List permanents = watcher.getThisTurnEnteringPermanents(opponentId);
                if (permanents == null) continue;
                for (Permanent permanent : permanents) {
                    if (!permanent.isCreature(game) || !permanent.getColor(game).isGreen()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return "an opponent had a green creature enter the battlefield under their control this turn";
    }
}

