/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.cards.p.PhantasmalSphereToken;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PhantasmalSphereEffect
extends OneShotEffect {
    PhantasmalSphereEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "target opponent creates an X/X blue Orb creature token with flying, where X is the number of +1/+1 counters on {this}";
    }

    private PhantasmalSphereEffect(PhantasmalSphereEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhantasmalSphereEffect copy() {
        return new PhantasmalSphereEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && targetOpponent != null) {
            CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new PhantasmalSphereToken(new CountersSourceCount(CounterType.P1P1).calculate(game, source, null)));
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetOpponent.getId()));
            effect.apply(game, source);
        }
        return false;
    }
}

