/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.AsEntersBattlefieldAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.ChooseBasicLandTypeEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;

public final class PhantasmalTerrain
extends CardImpl {
    public PhantasmalTerrain(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{U}{U}");
        this.subtype.add((Object)SubType.AURA);
        TargetLandPermanent auraTarget = new TargetLandPermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Detriment));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new AsEntersBattlefieldAbility((Effect)new ChooseBasicLandTypeEffect(Outcome.Neutral)));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new PhantasmalTerrainContinuousEffect()));
    }

    private PhantasmalTerrain(PhantasmalTerrain card) {
        super((CardImpl)card);
    }

    public PhantasmalTerrain copy() {
        return new PhantasmalTerrain(this);
    }

    private static class PhantasmalTerrainContinuousEffect
    extends ContinuousEffectImpl {
        private PhantasmalTerrainContinuousEffect() {
            super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
            this.staticText = "Enchanted land is the chosen type";
        }

        private PhantasmalTerrainContinuousEffect(PhantasmalTerrainContinuousEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public PhantasmalTerrainContinuousEffect copy() {
            return new PhantasmalTerrainContinuousEffect(this);
        }

        public void init(Ability source, Game game) {
            super.init(source, game);
            SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
            if (choice == null) {
                this.discard();
                return;
            }
            switch (choice) {
                case FOREST: {
                    this.dependencyTypes.add(DependencyType.BecomeForest);
                    break;
                }
                case PLAINS: {
                    this.dependencyTypes.add(DependencyType.BecomePlains);
                    break;
                }
                case MOUNTAIN: {
                    this.dependencyTypes.add(DependencyType.BecomeMountain);
                    break;
                }
                case ISLAND: {
                    this.dependencyTypes.add(DependencyType.BecomeIsland);
                    break;
                }
                case SWAMP: {
                    this.dependencyTypes.add(DependencyType.BecomeSwamp);
                }
            }
        }

        public boolean apply(Game game, Ability source) {
            Permanent enchantment = game.getPermanent(source.getSourceId());
            SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
            if (enchantment == null || enchantment.getAttachedTo() == null || choice == null) {
                return false;
            }
            Permanent land = game.getPermanent(enchantment.getAttachedTo());
            if (land == null) {
                return false;
            }
            land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
            land.addSubType(game, new SubType[]{choice});
            land.removeAllAbilities(source.getSourceId(), game);
            switch (choice) {
                case FOREST: {
                    land.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
                    break;
                }
                case PLAINS: {
                    land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                    break;
                }
                case MOUNTAIN: {
                    land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
                    break;
                }
                case ISLAND: {
                    land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
                    break;
                }
                case SWAMP: {
                    land.addAbility((Ability)new BlackManaAbility(), source.getSourceId(), game);
                }
            }
            return true;
        }
    }
}

