/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeOpponentsEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;

class PharikasSpawnDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private static final FilterPermanent filter = new FilterCreaturePermanent("a non-Gorgon creature");

    PharikasSpawnDelayedTriggeredAbility() {
        super((Effect)new SacrificeOpponentsEffect(filter), Duration.EndOfTurn, true);
    }

    private PharikasSpawnDelayedTriggeredAbility(PharikasSpawnDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public PharikasSpawnDelayedTriggeredAbility copy() {
        return new PharikasSpawnDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getTargetId().equals(this.getSourceId());
    }

    public String getRule() {
        return "When it enters the battlefield this way, each opponent sacrifices a non-Gorgon creature.";
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.GORGON.getPredicate()));
    }
}

