/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class PhenomenonInvestigatorsReturnCost
extends CostImpl {
    private static final FilterPermanent filter = new FilterNonlandPermanent("a nonland permanent you own");

    PhenomenonInvestigatorsReturnCost() {
        this.addTarget((Target)new TargetPermanent(filter).withNotTarget(true));
        this.text = "return a nonland permanent you own to your hand";
    }

    private PhenomenonInvestigatorsReturnCost(PhenomenonInvestigatorsReturnCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null && this.getTargets().choose(Outcome.ReturnToHand, controllerId, source.getSourceId(), source, game)) {
            Permanent permanentToReturn = game.getPermanent(this.getTargets().getFirstTarget());
            if (permanentToReturn == null) {
                return false;
            }
            controller.moveCards((Card)permanentToReturn, Zone.HAND, ability, game);
            this.paid = true;
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    public PhenomenonInvestigatorsReturnCost copy() {
        return new PhenomenonInvestigatorsReturnCost(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

