/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class PhosphorescentFeastEffect
extends OneShotEffect {
    PhosphorescentFeastEffect() {
        super(Outcome.GainLife);
    }

    private PhosphorescentFeastEffect(PhosphorescentFeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhosphorescentFeastEffect copy() {
        return new PhosphorescentFeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInHand target;
        int chroma = 0;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.getHand().count(new FilterCard(), game) > 0 && player.choose(Outcome.Benefit, (Target)(target = new TargetCardInHand(0, Integer.MAX_VALUE, new FilterCard())), source, game)) {
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            player.revealCards(source, (Cards)cards, game);
            for (Card card : cards.getCards(game)) {
                chroma += card.getManaCost().getMana().getGreen();
            }
            player.gainLife(chroma * 2, game, source);
        }
        return true;
    }
}

