/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class PhylacteryLichEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("artifact");

    public PhylacteryLichEffect() {
        super(Outcome.Neutral);
        this.staticText = "put a phylactery counter on an artifact you control";
    }

    private PhylacteryLichEffect(PhylacteryLichEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        TargetControlledPermanent target;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && (target = new TargetControlledPermanent(1, 1, filter, true)).canChoose(source.getControllerId(), source, game) && player.choose(Outcome.Neutral, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            permanent.addCounters(CounterType.PHYLACTERY.createInstance(), source.getControllerId(), source, game);
        }
        return false;
    }

    public PhylacteryLichEffect copy() {
        return new PhylacteryLichEffect(this);
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
    }
}

