/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class PhyrexianAtlasEffect
extends OneShotEffect {
    PhyrexianAtlasEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent who has three or more poison counters loses 1 life";
    }

    private PhyrexianAtlasEffect(PhyrexianAtlasEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianAtlasEffect copy() {
        return new PhyrexianAtlasEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getCountersCount(CounterType.POISON) < 3) continue;
            player.loseLife(1, game, source, false);
        }
        return true;
    }
}

