/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.p.PhyrexianCensorWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;

class PhyrexianCensorEffect
extends ContinuousRuleModifyingEffectImpl {
    PhyrexianCensorEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Each player can't cast more than one non-Phyrexian spell each turn";
    }

    private PhyrexianCensorEffect(PhyrexianCensorEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return "Each player can't cast more than one non-Phyrexian spell each turn";
    }

    public PhyrexianCensorEffect copy() {
        return new PhyrexianCensorEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        return card != null && !card.hasSubtype(SubType.PHYREXIAN, game) && PhyrexianCensorWatcher.checkPlayer(event.getPlayerId(), game);
    }
}

