/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PhyrexianFurnaceEffect
extends OneShotEffect {
    PhyrexianFurnaceEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the bottom card of target player's graveyard";
    }

    private PhyrexianFurnaceEffect(PhyrexianFurnaceEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianFurnaceEffect copy() {
        return new PhyrexianFurnaceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            Card bottomCard = null;
            Iterator iterator = player.getGraveyard().getCards(game).iterator();
            if (iterator.hasNext()) {
                Card card;
                bottomCard = card = (Card)iterator.next();
            }
            if (bottomCard != null) {
                return player.moveCardToExileWithInfo(bottomCard, null, "", source, game, Zone.GRAVEYARD, true);
            }
            return true;
        }
        return false;
    }
}

