/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PhyrexianGrimoireEffect
extends OneShotEffect {
    PhyrexianGrimoireEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Target opponent chooses one of the top two cards of your graveyard. Exile that card and put the other one into your hand";
    }

    private PhyrexianGrimoireEffect(PhyrexianGrimoireEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianGrimoireEffect copy() {
        return new PhyrexianGrimoireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && opponent != null) {
            if (!controller.getGraveyard().isEmpty()) {
                CardsImpl cards = new CardsImpl();
                UUID card1 = null;
                UUID card2 = null;
                for (UUID cardId : controller.getGraveyard()) {
                    card2 = card1;
                    card1 = cardId;
                }
                if (card1 != null) {
                    cards.add(card1);
                }
                if (card2 != null) {
                    cards.add(card2);
                }
                TargetCard target = new TargetCard(Zone.GRAVEYARD, new FilterCard());
                target.setRequired(true);
                if (opponent.choose(Outcome.Exile, (Cards)cards, target, source, game)) {
                    Card card = game.getCard(target.getFirstTarget());
                    cards.remove((Object)target.getFirstTarget());
                    if (card != null) {
                        controller.moveCards(card, Zone.EXILED, source, game);
                    }
                    if (!cards.isEmpty() && (card = game.getCard((UUID)cards.iterator().next())) != null) {
                        controller.moveCards(card, Zone.HAND, source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

