/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.NalaarAetherjetToken;
import mage.players.Player;

class PiaNalaarChiefMechanicEffect
extends OneShotEffect {
    public PiaNalaarChiefMechanicEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay one or more {E}. If you do, create an X/X colorless Vehicle artifact token named Nalaar Aetherjet with flying and crew 2, where X is the amount of {E} paid this way";
    }

    public PiaNalaarChiefMechanicEffect(PiaNalaarChiefMechanicEffect effect) {
        super((OneShotEffect)effect);
    }

    public PiaNalaarChiefMechanicEffect copy() {
        return new PiaNalaarChiefMechanicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int energyToPay = controller.getAmount(1, controller.getCountersCount(CounterType.ENERGY), "Pay 1 or more {E}", source, game);
        if (energyToPay == 0) {
            return true;
        }
        PayEnergyCost cost = new PayEnergyCost(energyToPay);
        if (cost.pay(source, game, source, controller.getId(), true)) {
            NalaarAetherjetToken token = new NalaarAetherjetToken(energyToPay);
            token.putOntoBattlefield(1, game, source);
            return true;
        }
        return false;
    }
}

