/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PiasRevolutionReturnEffect
extends OneShotEffect {
    PiasRevolutionReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return that card to your hand unless target opponent has {this} deal 3 damage to them";
    }

    private PiasRevolutionReturnEffect(PiasRevolutionReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public PiasRevolutionReturnEffect copy() {
        return new PiasRevolutionReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player opponent;
            UUID permanentId = (UUID)this.getValue("permanentId");
            Permanent permanent = game.getPermanentOrLKIBattlefield(permanentId);
            if (permanent != null && (opponent = game.getPlayer(source.getFirstTarget())) != null) {
                if (opponent.chooseUse(this.outcome, "Have Pia's Revolution deal 3 damage to you to prevent that " + permanent.getIdName() + " returns to " + controller.getName() + "'s hand?", source, game)) {
                    opponent.damage(3, source.getSourceId(), source, game);
                } else if (game.getState().getZone(permanent.getId()) == Zone.GRAVEYARD) {
                    controller.moveCards(game.getCard(permanentId), Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

