/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttachedToPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class PietyCharm
extends CardImpl {
    private static final FilterPermanent filter1 = new FilterPermanent("Aura attached to a creature");
    private static final FilterCreaturePermanent filter2 = new FilterCreaturePermanent("Soldier creature");

    public PietyCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{W}");
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter1));
        Mode mode = new Mode((Effect)new BoostTargetEffect(2, 2, Duration.EndOfTurn));
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filter2));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new GainAbilityAllEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES));
        this.getSpellAbility().addMode(mode);
    }

    private PietyCharm(PietyCharm card) {
        super((CardImpl)card);
    }

    public PietyCharm copy() {
        return new PietyCharm(this);
    }

    static {
        filter1.add((Predicate)SubType.AURA.getPredicate());
        filter1.add((ObjectSourcePlayerPredicate)new AttachedToPredicate((FilterPermanent)new FilterCreaturePermanent()));
        filter2.add((Predicate)SubType.SOLDIER.getPredicate());
    }
}

