/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.Choice;
import mage.choices.ChoiceCardType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PippinGuardOfTheCitadelEffect
extends OneShotEffect {
    PippinGuardOfTheCitadelEffect() {
        super(Outcome.Benefit);
        this.staticText = "another target creature you control gains protection from the card type of your choice until end of turn";
    }

    private PippinGuardOfTheCitadelEffect(PippinGuardOfTheCitadelEffect effect) {
        super((OneShotEffect)effect);
    }

    public PippinGuardOfTheCitadelEffect copy() {
        return new PippinGuardOfTheCitadelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        ChoiceCardType choice = new ChoiceCardType();
        player.choose(this.outcome, (Choice)choice, game);
        CardType cardType = CardType.fromString((String)choice.getChoice());
        FilterCard filter = new FilterCard(cardType.getPluralName().toLowerCase());
        filter.add((Predicate)cardType.getPredicate());
        game.addEffect(new GainAbilityTargetEffect((Ability)new ProtectionAbility((Filter)filter)).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

