/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PlagueBoilerSacrificeDestroyEffect
extends OneShotEffect {
    PlagueBoilerSacrificeDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "sacrifice it. If you do, destroy all nonland permanents";
    }

    private PlagueBoilerSacrificeDestroyEffect(PlagueBoilerSacrificeDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlagueBoilerSacrificeDestroyEffect copy() {
        return new PlagueBoilerSacrificeDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && sourcePermanent.sacrifice(source, game)) {
            return new DestroyAllEffect((FilterPermanent)new FilterNonlandPermanent()).apply(game, source);
        }
        return false;
    }
}

