/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PlagueBoilerSacrificeDestroyEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PlagueBoilerTriggeredAbility
extends TriggeredAbilityImpl {
    public PlagueBoilerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PlagueBoilerSacrificeDestroyEffect(), false);
        this.setTriggerPhrase("When {this} has three or more plague counters on it, ");
    }

    private PlagueBoilerTriggeredAbility(PlagueBoilerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PlagueBoilerTriggeredAbility copy() {
        return new PlagueBoilerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent;
        return event.getTargetId().equals(this.getSourceId()) && event.getData().equals(CounterType.PLAGUE.getName()) && (sourcePermanent = game.getPermanent(this.getSourceId())) != null && sourcePermanent.getCounters(game).getCount(CounterType.PLAGUE) >= 3;
    }
}

