/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.RatToken;
import mage.players.Player;
import mage.players.PlayerList;

class PlagueOfVerminEffect
extends OneShotEffect {
    PlagueOfVerminEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Starting with you, each player may pay any amount of life. Repeat this process until no one pays life. Each player creates a 1/1 black Rat creature token for each 1 life they paid this way.";
    }

    private PlagueOfVerminEffect(PlagueOfVerminEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlagueOfVerminEffect copy() {
        return new PlagueOfVerminEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, Integer> payLife = new HashMap<UUID, Integer>();
        if (controller != null) {
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
                playerList.getNext();
            }
            Player currentPlayer = game.getPlayer((UUID)playerList.get());
            UUID firstInactivePlayer = null;
            while (controller.canRespond()) {
                if (firstInactivePlayer == null) {
                    firstInactivePlayer = currentPlayer.getId();
                }
                if (currentPlayer != null && currentPlayer.canRespond() && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) {
                    int currentLifePaid = 0;
                    int totalPaidLife = 0;
                    if (currentPlayer.chooseUse(Outcome.AIDontUseIt, "Pay life?", source, game)) {
                        totalPaidLife = currentPlayer.getAmount(0, controller.getLife(), "Pay how many life?", source, game);
                        if (totalPaidLife > 0) {
                            currentPlayer.loseLife(totalPaidLife, game, source, false);
                            if (payLife.get(currentPlayer.getId()) == null) {
                                payLife.put(currentPlayer.getId(), totalPaidLife);
                            } else {
                                currentLifePaid = (Integer)payLife.get(currentPlayer.getId());
                                payLife.put(currentPlayer.getId(), currentLifePaid + totalPaidLife);
                            }
                        }
                        Card sourceCard = game.getCard(source.getSourceId());
                        game.informPlayers((sourceCard != null ? sourceCard.getName() : "") + ": " + currentPlayer.getLogName() + " pays " + payLife.get(currentPlayer.getId()) + " life");
                        firstInactivePlayer = null;
                    }
                }
                playerList.getNext();
                currentPlayer = game.getPlayer((UUID)playerList.get());
                if (!currentPlayer.getId().equals(firstInactivePlayer)) continue;
            }
            RatToken token = new RatToken();
            for (Map.Entry entry : payLife.entrySet()) {
                Player player = game.getPlayer((UUID)entry.getKey());
                if (player == null) continue;
                token.putOntoBattlefield(((Integer)entry.getValue()).intValue(), game, source, player.getId());
            }
        }
        return true;
    }
}

