/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.p.PlagueReaverReturnEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PlagueReaverDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID playerId;

    PlagueReaverDelayedTriggeredAbility(UUID playerId, Ability source) {
        super((Effect)new PlagueReaverReturnEffect(playerId).setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), source.getStackMomentSourceZCC() + 1)), Duration.Custom, true, false);
        this.playerId = playerId;
    }

    private PlagueReaverDelayedTriggeredAbility(PlagueReaverDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.playerId = ability.playerId;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.isActivePlayer(this.playerId);
    }

    public PlagueReaverDelayedTriggeredAbility copy() {
        return new PlagueReaverDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Return {this} to the battlefield under that player's control at the beginning of their next upkeep.";
    }
}

