/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;

class PlanarGuideReturnFromExileEffect
extends OneShotEffect {
    PlanarGuideReturnFromExileEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "At the beginning of the next end step, return those cards to the battlefield under their owners' control";
    }

    private PlanarGuideReturnFromExileEffect(PlanarGuideReturnFromExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlanarGuideReturnFromExileEffect copy() {
        return new PlanarGuideReturnFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ExileZone exile = game.getExile().getExileZone(source.getSourceId());
            if (exile != null) {
                controller.moveCards(exile.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            }
            return true;
        }
        return false;
    }
}

