/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PlaneswalkersMirthEffect
extends OneShotEffect {
    PlaneswalkersMirthEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent reveals a card at random from their hand. You gain life equal to that card's mana value";
    }

    private PlaneswalkersMirthEffect(PlaneswalkersMirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player player = game.getPlayer(source.getControllerId());
        if (opponent != null && player != null && !opponent.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            Card card = opponent.getHand().getRandom(game);
            if (card != null) {
                revealed.add(card);
                opponent.revealCards("Planeswalker's Mirth", (Cards)revealed, game);
                player.gainLife(card.getManaValue(), game, source);
            }
            return true;
        }
        return false;
    }

    public PlaneswalkersMirthEffect copy() {
        return new PlaneswalkersMirthEffect(this);
    }
}

