/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class PlaneswalkersMischiefCondition
implements Condition {
    protected UUID exileId;
    protected UUID cardId;

    public PlaneswalkersMischiefCondition(UUID exileId, UUID cardId) {
        this.exileId = exileId;
        this.cardId = cardId;
    }

    public boolean apply(Game game, Ability source) {
        List spells;
        if (!game.getExile().getExileZone(this.exileId).contains((Object)this.cardId)) {
            return false;
        }
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher != null && (spells = watcher.getSpellsCastThisTurn(source.getControllerId())) != null) {
            for (Spell spell : spells) {
                if (!spell.getSourceId().equals(this.cardId)) continue;
                return false;
            }
        }
        return true;
    }
}

