/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PlaneswalkersScornEffect
extends OneShotEffect {
    PlaneswalkersScornEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent reveals a card at random from their hand. Target creature gets -X/-X until end of turn, where X is the revealed card's mana value";
    }

    private PlaneswalkersScornEffect(PlaneswalkersScornEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(((Target)source.getTargets().get(0)).getFirstTarget());
        if (opponent != null && !opponent.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            Card card = opponent.getHand().getRandom(game);
            if (card != null) {
                revealed.add(card);
                int boostValue = -1 * card.getManaValue();
                opponent.revealCards("Planeswalker's Scorn", (Cards)revealed, game);
                BoostTargetEffect effect = new BoostTargetEffect(boostValue, boostValue, Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(((Target)source.getTargets().get(1)).getFirstTarget()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }

    public PlaneswalkersScornEffect copy() {
        return new PlaneswalkersScornEffect(this);
    }
}

