/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

enum PlateArmorAdjuster implements CostAdjuster
{
    instance;

    private static final FilterPermanent filter;
    private static final DynamicValue equipmentCount;
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public void reduceCost(Ability ability, Game game) {
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller != null) {
            int count = equipmentCount.calculate(game, ability, null);
            CardUtil.reduceCost((Ability)ability, (int)count);
        }
    }

    static {
        filter = new FilterControlledPermanent(SubType.EQUIPMENT, "Other Equipment you control");
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        equipmentCount = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Other Equipment you control", equipmentCount);
    }
}

