/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class PlatedPegasusEffect
extends PreventionEffectImpl {
    PlatedPegasusEffect() {
        super(Duration.WhileOnBattlefield, 1, false, false);
        this.staticText = "If a spell would deal damage to a permanent or player, prevent 1 damage that spell would deal to that permanent or player.";
    }

    private PlatedPegasusEffect(PlatedPegasusEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null) {
            stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
        }
        if (stackObject instanceof Spell) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public PlatedPegasusEffect copy() {
        return new PlatedPegasusEffect(this);
    }
}

