/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayVariableLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PlungeIntoDarknessSearchEffect
extends OneShotEffect {
    PlungeIntoDarknessSearchEffect() {
        super(Outcome.Benefit);
        this.staticText = "pay X life, then look at the top X cards of your library, put one of those cards into your hand, and exile the rest.";
    }

    private PlungeIntoDarknessSearchEffect(PlungeIntoDarknessSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlungeIntoDarknessSearchEffect copy() {
        return new PlungeIntoDarknessSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            PayVariableLifeCost cost = new PayVariableLifeCost();
            int xValue = cost.announceXValue(source, game);
            cost.getFixedCostsFromAnnouncedValue(xValue).pay(source, game, source, source.getControllerId(), false, null);
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
            controller.lookAtCards(source, null, (Cards)cards, game);
            TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand"));
            if (controller.choose(Outcome.DrawCard, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                cards.remove(card);
                controller.moveCards(card, Zone.HAND, source, game);
            }
            controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }
}

