/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class PolJamaarIllusionistEffect
extends OneShotEffect {
    PolJamaarIllusionistEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature type. Draw a card for each creature you control of that type";
    }

    private PolJamaarIllusionistEffect(PolJamaarIllusionistEffect effect) {
        super((OneShotEffect)effect);
    }

    public PolJamaarIllusionistEffect copy() {
        return new PolJamaarIllusionistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceCreatureType choice = new ChoiceCreatureType(game, source);
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        SubType subType = SubType.byDescription((String)choice.getChoiceKey());
        game.informPlayers(player.getLogName() + " chooses " + subType);
        int amount = game.getBattlefield().count((FilterPermanent)new FilterControlledCreaturePermanent(subType), source.getControllerId(), source, game);
        return amount > 0 && player.drawCards(amount, source, game) > 0;
    }
}

