/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.EscapeAbility;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PolukranosUnchainedEffect
extends OneShotEffect {
    PolukranosUnchainedEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "with six +1/+1 counters on it. It escapes with twelve +1/+1 counters on it instead";
    }

    private PolukranosUnchainedEffect(PolukranosUnchainedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        if (permanent == null) {
            return false;
        }
        SpellAbility spellAbility = (SpellAbility)this.getValue("sourceCastSpellAbility");
        int counters = 12;
        if (!(spellAbility instanceof EscapeAbility) || !spellAbility.getSourceId().equals(source.getSourceId()) || permanent.getZoneChangeCounter(game) != spellAbility.getStackMomentSourceZCC()) {
            counters = 6;
        }
        ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
        permanent.addCounters(CounterType.P1P1.createInstance(counters), source.getControllerId(), source, game, (List)appliedEffects);
        return true;
    }

    public PolukranosUnchainedEffect copy() {
        return new PolukranosUnchainedEffect(this);
    }
}

