/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PolymorphistsJestEffect
extends ContinuousEffectImpl {
    PolymorphistsJestEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "Until end of turn, each creature target player controls loses all abilities and becomes a blue Frog with base power and toughness 1/1";
    }

    private PolymorphistsJestEffect(PolymorphistsJestEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public PolymorphistsJestEffect copy() {
        return new PolymorphistsJestEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, this.getTargetPointer().getFirst(game, source), source, game).stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(this.affectedObjectList::add);
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent == null) {
                it.remove();
                continue;
            }
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.removeAllCreatureTypes(game);
                    permanent.addSubType(game, new SubType[]{SubType.FROG});
                    break;
                }
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setColor(ObjectColor.BLUE);
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    permanent.removeAllAbilities(source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(1);
                    permanent.getToughness().setModifiedBaseValue(1);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.ColorChangingEffects_5 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }
}

