/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.keyword.ToxicAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PorcelainZealotEffect
extends OneShotEffect {
    PorcelainZealotEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature you control gets +1/+1 until end of turn. If that creature has toxic, instead it gets +2/+2 until end of turn.";
    }

    private PorcelainZealotEffect(PorcelainZealotEffect effect) {
        super((OneShotEffect)effect);
    }

    public PorcelainZealotEffect copy() {
        return new PorcelainZealotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        Boolean targetHasToxic = creature.getAbilities().containsClass(ToxicAbility.class);
        if (targetHasToxic.booleanValue()) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 2, Duration.EndOfTurn), source);
        } else {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(1, 1, Duration.EndOfTurn), source);
        }
        return true;
    }
}

