/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PortentEffect
extends OneShotEffect {
    PortentEffect() {
        super(Outcome.DrawCard);
        this.staticText = "look at the top three cards of target player's library, then put them back in any order. You may have that player shuffle";
    }

    private PortentEffect(PortentEffect effect) {
        super((OneShotEffect)effect);
    }

    public PortentEffect copy() {
        return new PortentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        controller.lookAtCards(source, null, (Cards)cards, game);
        controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
        if (controller.chooseUse(Outcome.Neutral, "You may have that player shuffle", source, game)) {
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

