/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class PossessedPortalEffect
extends OneShotEffect {
    PossessedPortalEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player sacrifices a permanent unless they discard a card";
    }

    private PossessedPortalEffect(PossessedPortalEffect effect) {
        super((OneShotEffect)effect);
    }

    public PossessedPortalEffect copy() {
        return new PossessedPortalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            TargetSacrifice target;
            Player player = game.getPlayer(playerId);
            if (player == null || !player.getHand().isEmpty() && player.chooseUse(Outcome.Discard, "Discard a card or sacrifice a permanent?", null, "Discard a card", "Sacrifice a permanent", source, game) && !player.discard(1, false, false, source, game).isEmpty() || !(target = new TargetSacrifice(StaticFilters.FILTER_PERMANENT)).canChoose(player.getId(), source, game)) continue;
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

