/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.p.PowerSurgeWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PowerSurgeDamageEffect
extends OneShotEffect {
    PowerSurgeDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to that player, where X is the number of untapped lands they controlled at the beginning of this turn";
    }

    private PowerSurgeDamageEffect(PowerSurgeDamageEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        PowerSurgeWatcher watcher;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (watcher = (PowerSurgeWatcher)game.getState().getWatcher(PowerSurgeWatcher.class)) != null) {
            int damage = watcher.getUntappedLandCount();
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public PowerSurgeDamageEffect copy() {
        return new PowerSurgeDamageEffect(this);
    }
}

