/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class PowerbalanceEffect
extends OneShotEffect {
    PowerbalanceEffect() {
        super(Outcome.Neutral);
        this.staticText = "you may reveal the top card of your library. If you do, you may cast that card without paying its mana cost if the two spells have the same mana value";
    }

    private PowerbalanceEffect(PowerbalanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public PowerbalanceEffect copy() {
        return new PowerbalanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null && (spell = (Spell)game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source))) != null) {
            Card topcard = controller.getLibrary().getFromTop(game);
            if (topcard != null) {
                CardsImpl cards = new CardsImpl();
                cards.add(topcard);
                controller.revealCards(sourcePermanent.getName(), (Cards)cards, game);
                if (topcard.getManaValue() == spell.getManaValue()) {
                    return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)topcard);
                }
            }
            return true;
        }
        return false;
    }
}

