/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.Zone;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.other.PlayerWithTheMostLifePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class PreacherOfTheSchismSecondTrigger
extends TriggeredAbilityImpl {
    public PreacherOfTheSchismSecondTrigger() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1, true), false);
        this.addEffect((Effect)new LoseLifeSourceControllerEffect(1).concatBy("and"));
        this.setTriggerPhrase("Whenever {this} attacks while you have the most life or are tied for most life, ");
    }

    protected PreacherOfTheSchismSecondTrigger(PreacherOfTheSchismSecondTrigger ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PreacherOfTheSchismSecondTrigger copy() {
        return new PreacherOfTheSchismSecondTrigger(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defenderId = game.getCombat().getDefenderId(this.getSourceId());
        if (defenderId == null) {
            return false;
        }
        Player controller = game.getPlayer(this.getControllerId());
        return PlayerWithTheMostLifePredicate.instance.apply(new ObjectSourcePlayer((Object)controller, this.getControllerId(), null), game);
    }
}

